<?php
/*
Template Name: Blog
*/
get_header();
$page_id = be_get_page_id();
global $be_themes_data, $blog_attr;
$blog_attr = array();
$items_per_page = get_option( 'posts_per_page' );
$blog_column = get_post_meta($page_id, 'be_themes_blog_column', true);
$blog_attr['gutter_style'] = get_post_meta($page_id, 'be_themes_blog_gutter_style', true);
$blog_attr['gutter_width'] = get_post_meta($page_id, 'be_themes_blog_gutter_width', true);
$blog_attr['pagination_style'] = get_post_meta($page_id, 'be_themes_blog_pagination_style', true);
$blog_attr['style'] = get_post_meta($page_id, 'be_themes_blog_style', true);
$sidebar = get_post_meta($page_id, 'be_themes_page_layout', true);
$blog_attr['gutter_style'] = ((!isset($blog_attr['gutter_style'])) || empty($blog_attr['gutter_style'])) ? 'style1' : $blog_attr['gutter_style'];
$blog_attr['gutter_width'] = ((!isset($blog_attr['gutter_width'])) || empty($blog_attr['gutter_width'])) ? intval(40) : intval( $blog_attr['gutter_width'] );
$blog_attr['pagination_style'] = ((!isset($blog_attr['pagination_style'])) || empty($blog_attr['pagination_style'])) ? 'normal' : $blog_attr['pagination_style'];
$blog_attr['style'] = ((!isset($blog_attr['style'])) || empty($blog_attr['style'])) ? 'style1' : $blog_attr['style'];
$blog_column = ((!isset($blog_column)) || empty($blog_column)) ? 'three-col' : $blog_column;
$sidebar = ((!isset($sidebar)) || empty($sidebar)) ? 'right' : $sidebar;
if( $blog_attr['style'] == 'style3' ) {
	$sidebar = 'no';
	$blog_style_class = $blog_attr['style'].'-blog portfolio-container clickable clearfix';
} else {
	$blog_style_class = $blog_attr['style'].'-blog';
}
if($blog_attr['style'] == 'style3' && $blog_attr['gutter_style'] == 'style2') {
	$portfolio_wrap_style = 'style="margin-left: -'.$blog_attr['gutter_width'].'px;"';
	$portfolio_pagination_style = 'style="margin-left: '.$blog_attr['gutter_width'].'px; margin-top: '.(40-(intval($blog_attr['gutter_width']) > 40) ? 0 : intval($blog_attr['gutter_width'])).'px;"';
} else {
	$portfolio_pagination_style = $portfolio_wrap_style = 'style="margin-left: 0px;"';
}
?>
<section id="blog-content" class="no-sidebar-page">
	<div class="clearfix">
		<?php
			if(isset($be_themes_data['blog_page_show_page_title_module']) && !empty($be_themes_data['blog_page_show_page_title_module']) && $be_themes_data['blog_page_show_page_title_module'] == 1) {
				get_template_part( 'page-breadcrumb' );
			}
		?>
	</div> <!--  End Page Content -->
</section>
<section id="content" class="<?php echo esc_attr( $sidebar ); ?>-sidebar-page">
	<div id="content-wrap" class="be-wrap clearfix"> 
		<section id="page-content" class="<?php echo ($blog_attr['style'] == 'style3' || $sidebar == 'no') ? 'content-no-sidebar' : 'content-single-sidebar'; ?>">
			<div class="portfolio-all-wrap">
				<div class="<?php echo ($blog_attr['style'] == 'style3') ? 'portfolio full-screen full-screen-gutter '.$blog_attr['gutter_style'].'-gutter '.$blog_column : ''; ?>" data-gutter-width="<?php echo esc_attr( $blog_attr['gutter_width'] ); ?>" data-showposts="<?php echo esc_attr( $items_per_page ); ?>" data-paged="2" data-action="get_blog" <?php echo esc_attr( $portfolio_wrap_style ); ?> >
					<div class="clearfix <?php echo esc_attr( $blog_style_class ); ?>">
						<?php 			
						$args = array (
							'post_status'=> 'publish',
							'ignore_sticky_posts'=> true
						);
						query_posts($args);		
						if( have_posts() ) : 
							while ( have_posts() ) : the_post();
								$blog_style = be_get_blog_loop_style( $blog_attr['style'] );
								get_template_part( 'blog/loop', $blog_style );
							endwhile;
						else:
							echo '<p class="element element-empty-message inner-content">'.__( 'Apologies, but no results were found. Perhaps searching will help find a related post.', 'be-themes' ).'</p>';
						endif;
						?>
					</div>
					<?php get_blog_pagination($blog_attr, $portfolio_pagination_style); ?>
				</div>
			</div>
		</section> <?php
		if($blog_attr['style'] != 'style3' && $sidebar != 'no') { ?>
			<section id="<?php echo esc_attr( $sidebar ); ?>-sidebar" class="sidebar-widgets">
				<?php get_sidebar(); ?>
			</section> <?php 
		} ?>
	</div>
</section>					
<?php get_footer(); ?>